' ToolPlugIn.vb
'
' This file declares a class that implements IPlugIn. The
' implementation creates a simple tool inside
' the user interface of the TLA.
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Imports Tektronix.LogicAnalyzer.PlugIn
Imports Tektronix.LogicAnalyzer.TpiNet
Imports System
Imports System.Windows.Forms

Namespace VBSamplePlugIn

    ' The use of the PlugInIdentity Attribute causes the TLA to create
    ' a tool bar button and a Tools menu item to represent the installed
    ' plug-in in the user interface. Pressing the toolbar button will
    ' activate a single instance of the plug-in and its UI.
    ' PlugInInstantiation Attribute is also applied to the clas. The 
    ' arguments to PlugInInstantiation cause a single instance of the 
    ' plug-in class to instantiated whenever the TLA system is defaulted.
    <PlugInIdentity("VB Sample Tool"), PlugInInstantiation(True, True)> _
    Public Class VBToolPlugIn
        Implements IPlugIn


        ' Data member declarations.
        Dim window As ToolForm = Nothing
        Dim instanceIsValid As Boolean = True
        Dim instanceIsGarbage As Boolean = False


        ' All plug-in classes must have a default constructor
        ' to be instantiated by the system.
        Public Sub New()
        End Sub

        ' IPlugIn Members
        '----------------

        ' The plug-in subscribes to ToolForm.Closed. This
        ' event handler is called when the event occurs.
        ' The plug-in responds by disposing itself, which
        ' deletes the plug-in instance from the system.
        Private Sub OnWindowClosed(ByVal sender As System.Object, ByVal e As System.EventArgs)
            Me.Dispose()
        End Sub
        Public Function Initialize(ByVal support As ITlaPlugInSupport, ByVal userInit As Boolean) As Boolean Implements IPlugIn.Initialize

            window = New ToolForm(support)
            support.TopLevelFormToChild(window)

            ' This lets the plug-in know when the user 
            ' closes the plug-in UI.
            AddHandler window.Closed, AddressOf Me.OnWindowClosed
            Return True
        End Function


        Public ReadOnly Property PrimaryForm() As Form Implements IPlugIn.PrimaryForm
            Get
                Return window
            End Get
        End Property


        'IDisposable Member
        '------------------

        ' This method invalidates the plug-in and disposes of its window.
        Public Sub Dispose() Implements IPlugIn.Dispose
            If Not Nothing Is window Then
                RemoveHandler window.Closed, AddressOf Me.OnWindowClosed
                window.Dispose()
            End If

            instanceIsValid = False
            instanceIsGarbage = True

            RaiseEvent ValidityChanged(Me, EventArgs.Empty)
        End Sub


        ' IValidity Members
        ' -----------------

        ' This event is raised whenever either of the two 
        ' properties below change.
        Public Event ValidityChanged As EventHandler _
            Implements IPlugIn.ValidityChanged

        ' Property that indicates whether the plug-in is 
        ' valid to be part of the system.
        Public ReadOnly Property IsValid() As Boolean Implements IPlugIn.IsValid
            Get
                Return instanceIsValid
            End Get
        End Property


        ' Property that indicates whether the plug-in is permanently
        ' invalid. This value should always be set to true when a
        ' plug-in is disposed.
        Public ReadOnly Property IsGarbage() As Boolean Implements IPlugIn.IsGarbage
            Get
                Return instanceIsGarbage
            End Get
        End Property
    End Class

End Namespace